clear;
clc;
rng(1); % random number generator

% ---- parameters ---- %
d = 6; % spatial dimension
N = 15; % data size
p = 4; % batch size

% ---- compute moments ---- %
x = randn(d,N); % [d,N] N vectors
[M,A4,A3B1,A2B2,AB2,B4] = fourth_moment(x,p);
[S4,S31,S22a,S22b,S211a,S211b,S1111] = symmetries(x);

% ---- verify equalities ---- %
e_A4  = 1/p^3*S4 + 4*(p-1)/p^3*S31 + (p-1)/p^3*S22a + 2*(p-1)/p^3*S22b + 2*(p-1)*(p-2)/p^3*S211a + 4*(p-1)*(p-2)/p^3*S211b + (p-1)*(p-2)*(p-3)/p^3*S1111 - A4;
e_A3B1 = 1/(p^2*N)*S4 + (3*p+N-4)/(p^2*N)*S31 + (p-1)/(p^2*N)*S22a + 2*(p-1)/(p^2*N)*S22b + (p-1)*(p+N-4)/(p^2*N)*S211a + 2*(p-1)*(p+N-4)/(p^2*N)*S211b + (p-1)*(p-2)*(N-3)/(p^2*N)*S1111 - A3B1;
e_A2B2 = 1/(p*N^2)*S4 + 2*(p+N-2)/(p*N^2)*S31 + (N-1)/(p*N^2)*S22a + 2*(p-1)/(p*N^2)*S22b + (p+N-2)*(N-2)/(p*N^2)*S211a + 4*(p-1)*(N-2)/(p*N^2)*S211b + (p-1)*(N-2)*(N-3)/(p*N^2)*S1111 - A2B2;
e_AB2 = 1/(p*N^2)*S4 + 2*(p+N-2)/(p*N^2)*S31 + (p-1)/(p*N^2)*S22a + (p+N-2)/(p*N^2)*S22b + 2*(p-1)*(N-2)/(p*N^2)*S211a + (3*p+N-4)*(N-2)/(p*N^2)*S211b + (p-1)*(N-2)*(N-3)/(p*N^2)*S1111 - AB2;
e_B4 = 1/N^3*S4 + 4*(N-1)/N^3*S31 + (N-1)/N^3*S22a + 2*(N-1)/N^3*S22b + 2*(N-1)*(N-2)/N^3*S211a + 4*(N-1)*(N-2)/N^3*S211b + (N-1)*(N-2)*(N-3)/N^3*S1111 - B4;

% ---- verify fourth moment ---- %
C_X = (N-p)*(N^2-3*N*p+3*p^2)/(N^3*p^3);
C_Y = (N-p)*(N^2*p-N*p^2-N^2+3*N*p-3*p^2)/(N^3*p^3);
C_Z = (N-p)*(N^2*p-N*p^2-2*N^2+6*N*p-6*p^2)/(N^3*p^3);
e_M = C_X*S4 - 4*C_X*S31 + C_Y*S22a + 2*C_Y*S22b - 2*C_Z*S211a - 4*C_Z*S211b + 3*C_Z*S1111 - M;
% ---- display error ---- %
disp(e_A4)
disp(e_A3B1)
disp(e_A2B2)
disp(e_AB2)
disp(e_B4)
disp(e_M)
